package gov.va.med.mhv.usermgmt.persist.ldap;

import netscape.ldap.LDAPException;

import org.springframework.dao.DataAccessException;

import gov.va.med.mhv.usermgmt.persist.DuplicateEntryException;
import gov.va.med.mhv.usermgmt.persist.GenericDataAccessException;
import gov.va.med.mhv.usermgmt.persist.NoSuchEntryException;

/**
 * Exception translation strategy that translates a directory-specific exception
 * into a data access-agnostic exception--specifically a subclass of Spring's
 * <code>org.springframework.dao.DataAccessException</code>.
 * <p>
 * This class could probably be covered by an interface, but that seems like
 * an unnecessary level of indirection at this point.  If necessary, an interface
 * can be extracted from this class if an additional implementation is necessary in the
 * future.
 *
 * @author Jon Crater Apr 13, 2006 10:45:39 AM
 */
public class LdapExceptionTranslator {
	public DataAccessException translate(LDAPException e) {
		switch (e.getLDAPResultCode()) {
			case LDAPException.NO_SUCH_OBJECT:
				return new NoSuchEntryException(e.errorCodeToString(), e);
			case LDAPException.ENTRY_ALREADY_EXISTS:
				return new DuplicateEntryException(e.errorCodeToString(), e);
			default:
				return new GenericDataAccessException(e.errorCodeToString(), e);
		}
	}
}
